"use strict";

const url = "listing.json";
const contentElement = document.querySelector('.content')

fetch(url)
    .then(convertJSON)
    .then(answer);


function convertJSON(response) {
    return response.json();
}


function answer(data) {
    console.log(data);

    let labNames = [];
    for (let labName in data) { labNames.push(labName); }
    labNames = labNames.sort();

    for (let labName of labNames) {
        const labElement = document.createElement("div");
        labElement.id = labName;
        labElement.classList.add("lab");
        contentElement.appendChild(labElement);


        const labNameElement = document.createElement("h2");
        labNameElement.textContent = labName;
        labNameElement.classList.add("labName");
        labElement.appendChild(labNameElement);

        const labFullName = data[labName]["Nom"];
        if (labFullName) {
            const labFullNameElement = document.createElement("div");
            labFullNameElement.textContent = labFullName;
            labFullNameElement.classList.add("labFullName");
            labElement.appendChild(labFullNameElement);
        }

        const labUMR = data[labName]["UMR"];
        if (labUMR) {
            const labUMRElement = document.createElement("div");
            labUMRElement.textContent = "UMR-" + labUMR + " CNRS";
            labUMRElement.classList.add("labUMR");
            labElement.appendChild(labUMRElement);
        }

        const labVille = data[labName]["Ville"];
        if (labVille) {
            const labVilleElement = document.createElement("div");
            labVilleElement.textContent = "Ville: " + labVille;
            labVilleElement.classList.add("labVille");
            labElement.appendChild(labVilleElement);
        }

        let labEquipes = data[labName]["Equipes"];
        if (labEquipes) {
            const labEquipesElement = document.createElement("div");
            labEquipesElement.classList.add("labEquipes");
            labElement.appendChild(labEquipesElement);

            for (let labEquipeName in labEquipes) {
                const labEquipeElement = document.createElement("div");
                labEquipeElement.id = labEquipeName;
                labEquipesElement.appendChild(labEquipeElement);

                const labEquipeNameElement = document.createElement("h3");
                labEquipeNameElement.textContent = labEquipeName;
                labEquipeNameElement.classList.add("labEquipeName");
                labEquipeElement.appendChild(labEquipeNameElement);
                
            }
        }

    }

}