import yaml


def htmlDiv(content,classList,id=''):
    html = '<div'
    if len(classList)>0:
        html += f' class=\"{classList}\"'
    if len(id)>0:
        html += f' id=\"{id}\"'
    html += '>'

    if len(content)>0:
        html += content
    html += '</div>'

    return html


f = open(r"listing.yml")
content = yaml.load(f, Loader=yaml.FullLoader)
f.close()


html = "\n<style>\n"
with open("style.css") as f:
    html += f.read()
html += "\n</style>\n\n\n"




labNames = sorted(content.keys())

for labName in labNames:
    lab = content[labName]
    labURL = lab['URL']

    html += '\t<div class="labSummaryEntry">'
    html += '[<a href=\"#'+labName+'\">#</a> <a href=\"'+labURL+'\"><span class="labName labNameSummary">'+labName+'</span></a>]</span>'

    if 'Equipes' in lab:
        html += " : "
        equipes = sorted(lab['Equipes'].keys())
        for equipeName in equipes:
            equipe = lab['Equipes'][equipeName]
            equipeURL = equipe['URL']

            html += '<span class="equipeSummaryEntry">[<a href=\"'+equipeURL+'\"><span class="equipeNameSummary">'+equipeName+'</span></a>]</span>'

    if labName=='Inria':
        for otherLabName in labNames:
            if otherLabName != 'Inria':
                if 'Equipes' in content[otherLabName]:
                    for otherTeam in content[otherLabName]['Equipes']:
                        if 'Inria' in content[otherLabName]['Equipes'][otherTeam]:
                            equipeName = otherTeam
                            equipeURL = content[otherLabName]['Equipes'][equipeName]['URL']
                            html += '<span class="equipeSummaryEntry">[<a href=\"'+equipeURL+'\"><span class="equipeNameSummary">'+equipeName+'</span></a>]</span>'

    if 'Ville' in lab:
        labVille = lab['Ville']
        html += ' <span class="labVilleSummary">('+labVille+')</span>'

    html += '</div>\n'


for labName in labNames:
    lab = content[labName]
    labURL = lab['URL']

    html += f'\t<div id=\"{labName}\" class=\"lab\">\n'
    html += f'\t\t<a href=\"{labURL}\"><h2 class=\"labName\">{labName}</h2></a>\n'

    html += f'\t\t<div class=\"labContent\">\n'
    
    
    if 'Nom' in lab:
        labFullName = content[labName]['Nom']
        html += '\t\t'+htmlDiv(labFullName,'labFullName')+'\n'
    if 'Ville' in lab:
        labVille = content[labName]['Ville']
        html += '\t\t'+htmlDiv('Ville: '+labVille,'labVille')+'\n'
    if 'UMR' in lab:
        labUMR = str(content[labName]['UMR'])
        html += '\t\t'+htmlDiv('CNRS UMR-'+labUMR,'labUMR')+'\n'

    if 'Correspondant' in lab:
        equipeCorrespondant = lab['Correspondant']
        html += '\t\t'+htmlDiv('<span class=\"equipeCorrespondantTitle\">Correspondant:</span> '+equipeCorrespondant,'equipeCorrespondant')+'\n'
    if 'Thèmes' in lab:
        equipeTheme = lab['Thèmes']
        html += '\t\t'+htmlDiv('<span class=\"equipeThemeTitle\">Thèmes:</span> '+equipeTheme,'equipeTheme')+'\n'

    if 'Equipes' in lab:
        equipes = sorted(lab['Equipes'].keys())
        for equipeName in equipes:
            equipe = lab['Equipes'][equipeName]
            equipeURL = equipe['URL']

            html += f'\t\t<div id=\"{equipeName}\" class=\"labEquipe\">\n'

            html += f"\t\t\t<a href=\"{equipeURL}\"><h3 class=\"equipeName\">{equipeName}</h3></a>\n"
            if 'Nom' in equipe:
                equipeFullName = equipe['Nom']
                html += '\t\t\t'+htmlDiv(equipeFullName,'equipeFullName')+'\n'
            if 'Ville' in equipe:
                equipeVille = equipe['Ville']
                html += '\t\t\t'+htmlDiv('<span class=\"equipeVilleTitle\">Ville:</span> '+equipeVille,'equipeVille')+'\n'
            if 'Correspondant' in equipe:
                equipeCorrespondant = equipe['Correspondant']
                html += '\t\t\t'+htmlDiv('<span class=\"equipeCorrespondantTitle\">Correspondant:</span> '+equipeCorrespondant,'equipeCorrespondant')+'\n'
            if 'Thèmes' in equipe:
                equipeTheme = equipe['Thèmes']
                html += '\t\t\t'+htmlDiv('<span class=\"equipeThemeTitle\">Thèmes:</span> '+equipeTheme,'equipeTheme')+'\n'
            if 'Inria' in equipe:
                html += '\t\t\t'+htmlDiv('Equipe Commune Inria', 'equipeInria')+'\n'

            html += '\t\t</div>\n'

    if labName=='Inria':
        for otherLabName in labNames:
            if otherLabName != 'Inria':
                if 'Equipes' in content[otherLabName]:
                    for otherTeam in content[otherLabName]['Equipes']:
                        if 'Inria' in content[otherLabName]['Equipes'][otherTeam]:

                            equipeName = otherTeam
                            equipeURL = content[otherLabName]['Equipes'][equipeName]['URL']

                            html += f'\t\t<div class=\"labEquipe\">\n'
                            html += f"\t\t\t<a href=\"{equipeURL}\"><h3 class=\"equipeName\">{equipeName}</h3></a>\n"
                            html += '\t\t\t<div class="equipeInriaCommune">Equipe commune avec le laboratoire '+otherLabName+'</div>\n'
                            html += '\t\t\t<div class="equipeInriaLien"><a href="#'+equipeName+'"># Lien descriptif</a></div>\n'
                            html += '\t\t</div>\n'

                            # html += '<span class="equipeSummaryEntry">[<a href=\"'+equipeURL+'\"><span class="equipeNameSummary">'+equipeName+'</span></a>]</span>'

    html += f'\t\t</div>\n'

    html += '\t</div>\n'



html += """
</body>

</html>"""


with open('index.html','w') as f:
    f.write(html)